import {
    View,
    TouchableOpacity,
    TextInput,
    FlatList,
    Pressable,
} from 'react-native';
import React from 'react';
import BackIcon from '../../../assets/svgs/backButton.svg';
import CommonStyles from '../../Utilities/CommonStyles/CommonStyles';
import { homeStyle } from '../../Home/homeStyle';
import dpr from '../../Utilities/CustomStyleAttribute/dpr';
import SearchIcon from '../../../assets/svgs/searchIcon.svg';
import RecentSearch from './RecentSearch';
import PopularProducts from './PopularProducts';
import BestSellers from './BestSellers';
import { featureDisplayStyle } from '../../Home/FeatureDIsplay/featureDisplay.style';
import { useNavigation } from '@react-navigation/native';
import { useDispatch } from 'react-redux';
import { resetSearchProduct } from '../../../redux/slices/searchProducts/searchProducts';
import useLangTranslation from '../../../hooks/useLangTranslation';
import CustomSVG from '../../../src/components/CustomSVG/CustomSVG';

const FilterHome = (props) => {
    const { trans } = useLangTranslation();
    const navigation = useNavigation();
    const dispatch = useDispatch();

    function debounce(func, timeout = 1000) {
        let timer;
        return (...args) => {
            clearTimeout(timer);
            timer = setTimeout(() => {
                func.apply(this, args);
            }, timeout);
        };
    }
    const processChange = async (text) => {
        if (text) {
            dispatch(resetSearchProduct());
            navigation.navigate('foundContent', {
                searchContent: text,
            });
        }
    };
    const handleSearch = debounce((text) => processChange(text));

    return (
        <>
            <View>
                <View style={CommonStyles.container}>
                    <TouchableOpacity
                        style={CommonStyles.customHeaderIcon}
                        onPress={() => props.navigation.goBack()}
                    >
                        <CustomSVG svgIcon={BackIcon} isRtl={1} />
                    </TouchableOpacity>
                </View>
                <View style={homeStyle.searchContainer}>
                    <TextInput
                        placeholder={trans('Search')}
                        style={homeStyle.searchTextField}
                        autoFocus={true}
                        onChangeText={(text) => handleSearch(text)}
                    />
                    <Pressable style={homeStyle.searchIcon}>
                        <CustomSVG svgIcon={SearchIcon} width={dpr(16)} height={dpr(16)} />
                    </Pressable>
                </View>
            </View>

            <View style={[featureDisplayStyle.const, featureDisplayStyle.pb0]}>
                <FlatList
                    keyboardShouldPersistTaps={'always'}
                    ListHeaderComponent={() => (
                        <>
                            <RecentSearch handleSearch={processChange} />
                            <PopularProducts />
                            <BestSellers />
                        </>
                    )}
                    showsVerticalScrollIndicator={false}
                />
            </View>
        </>
    );
};

export default FilterHome;
